/*
 * Copyright (c) 2010-2017 OTClient <https://github.com/edubart/otclient>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef OTMLDOCUMENT_H
#define OTMLDOCUMENT_H

#include "otmlnode.h"

class OTMLDocument : public OTMLNode
{
public:
    virtual ~OTMLDocument() { }

    /// Create a new OTML document for filling it with nodes
    static OTMLDocumentPtr create();

    /// Parse OTML from a file
    static OTMLDocumentPtr parse(const std::string& fileName);

    /// Parse OTML from a string
    static OTMLDocumentPtr parseString(const std::string& data, const std::string& source);

    /// Parse OTML from input stream
    /// @param source is the file name that will be used to show errors messages
    static OTMLDocumentPtr parse(std::istream& in, const std::string& source);

    /// Emits this document and all it's children to a std::string
    std::string emit();

    /// Save this document to a file
    bool save(const std::string& fileName);

private:
    OTMLDocument() { }
};

#endif
